import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { mutationResponse } from "../util/processResponse.js";

const initialState = {
    data: undefined,
};

export const decrementQtyFromCart = createAsyncThunk(
    "cart/decrementQtyFromCart",
    async (obj) => {
        const { access_token, decrementUrl, method, data } = obj;
        const response = await mutationResponse(
            decrementUrl,
            method,
            data,
            access_token
        );
        return response;
    }
);

const decrementQtyFromCartSlice = createSlice({
    name: "cart",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(decrementQtyFromCart.pending, (state) => {});
        builder.addCase(
            decrementQtyFromCart.fulfilled,
            (state, { payload }) => {}
        );
        builder.addCase(decrementQtyFromCart.rejected, (state) => {});
    },
});

export default decrementQtyFromCartSlice.reducer;
